--[[

NoteCase Pro sample script (requires Notecase Pro >= 4.1.2)

   See http://www.notecasepro.com/

SCRIPT NAME: Sync Diff Remote

   Version 1.0 

PURPOSE: Script compares current document with the instance of the document available at the configured sync server, displaying the list of differences in a message box.

RIGHTS: This script's author, Miroslav Rajcic, hereby waives all copyright and related or neighboring rights to this script, pursuant to the Creative Commons CC0 Universal relinquishment of rights found at http://creativecommons.org/publicdomain/zero/1.0/

--]]


nDocID = Nc_Doc_ID_GetCur()
bOk, strErr, nDbDocID = Nc_Sync_MatchDocument(nDocID)
if 1 == bOk then
	if -1 == nDbDocID then
		Nc_GUI_MessageBox("No matching document on sync server")
	else	
		bOk, strErr, tRes = Nc_Sync_DiffDocument(nDocID, nDbDocID)
		if 1 == bOk then
			strMsg = "Diff count=" .. #tRes .. "\n"
			for i=1,#tRes do
				strMsg = strMsg .. "OP=" .. tRes[i]['op'] .. ",\t"
				strMsg = strMsg .. "Note=" .. tRes[i]['note'] .. ",\t"
				strMsg = strMsg .. "Parent=" .. tRes[i]['parent'] .. ",\t"
				strMsg = strMsg .. "Pos='" .. tRes[i]['pos'] .. "'\n"
			end
			Nc_GUI_MessageBox(strMsg)
		else
			Nc_GUI_MessageBox("Connection failed: " .. strErr)
		end
	end
else
	Nc_GUI_MessageBox("Connection failed or no document match: "  .. strErr)
end	
