--[[

NoteCase Pro sample script (requires Notecase Pro >= 4.1.2)

   See http://www.notecasepro.com/

SCRIPT NAME: Dump Document File

   Version 1.0 

PURPOSE: Script uses "dump" infrastructure to load possibly corrupted NoteCase Pro document file
and store it into new file using more readable file format (that can be opened in text editor or in Sqlite viewer program)

RIGHTS: This script's author, Miroslav Rajcic, hereby waives all copyright and related or neighboring rights to this script, pursuant to the Creative Commons CC0 Universal relinquishment of rights found at http://creativecommons.org/publicdomain/zero/1.0/

--]]

function string.ends(String,End)
   return End=='' or string.sub(String,-string.len(End))==End
end

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 4 or (nMaj == 4 and nMin < 1) or (nMaj == 4 and nMin == 1 and nRev < 2)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 4.1.2")
	return
end

-- select file to be processed
strInputFile = Nc_GUI_FileDlg(0, "", "Select input document", "", 0, 0, 0, "NoteCase Pro compressed document (*.ncz)", "*.ncz", "NoteCase Pro encrypted document  (*.nce)", "*.nce", "NoteCase Pro encrypted DB document (*.ncde)", "*.ncde");
if string.len(strInputFile) == 0 then
	return
end

-- select output file 
strOutputFile = Nc_GUI_FileDlg(1, "", "Select destination document", "", 0, 0, 0, "NoteCase Pro plain text document (*.ncd)", "*.ncd", "NoteCase Pro database document (*.ncdb)", "*.ncdb");
if string.len(strOutputFile) == 0 then
	return
end

-- if input requires password ask for it
strPassword = ""
if string.ends(strInputFile, "nce") or string.ends(strInputFile, "ncde") then
	strPassword = Nc_GUI_InputDlg("Document Password", "", "", 1, 1)
end

-- now dump the file
Nc_Util_DumpDocumentData(strInputFile, strOutputFile, strPassword)

-- done
Nc_GUI_MessageBox("Done!");
