-- Notecase Pro sample script (requires Notecase Pro >= 3.1.4)
-- File Name: 39_ExportListToSimpleHtml.lua
-- Description:
-- Exports entire List Pane of notes to a simple HTML file with headings in bold face. 
-- (Notes will not be numbered and will have no hierarchy.)
-- 
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/ 

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 4)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.4")
	return
end

-- get currently active document's ID and store as variable nDocID
nDocID = Nc_Doc_ID_GetCur()

-- get count of notes in the List Pane
nListPaneCount = Nc_App_List_GetCount()

-- select or create a name for the HTML file and store its path as variable strFileName
strFileName = Nc_GUI_FileDlg(1, "", "Designate Export File")

-- error check: if file has not been selected abort the script.
if strFileName == "" then
	return
end

-- open HTML file
f = io.open(strFileName, "w")

-- write opening HTML and BODY tags 
f:write("<HTML>\n<HEAD>\n<meta content=\"text/html;charset=UTF-8\" http-equiv=\"Content-Type\">\n</HEAD>\n<BODY>\n")
	
-- for each List Pane note
for i=1,nListPaneCount do
	
	-- store note's ID as variable strNoteID and decrement the value of "i"
	strNoteID    = Nc_App_List_Note_GetID(i-1)

	-- store note's title and content as variables strNoteTitle and strNoteHtml
	strNoteTitle 	= Nc_Note_Title_Get(nDocID, strNoteID)
	strNoteHtml 	= Nc_Note_Content_Get(nDocID, strNoteID)
	
	-- in multi-line titles replace newline with space to make the title a single line
	strNoteTitle = string.gsub(strNoteTitle, "\n", " ") 

	-- write note's title as bold face paragraph followed by a blank line
	f:write("<p><b>" .. strNoteTitle .. "</b></p>\n")

	-- write note's content
	f:write(strNoteHtml)
	
	-- make note end with two blank lines to separate from next note's title
	f:write("<p></p>\n")

end

-- comment the next line if you do not want to brag about using NoteCase Pro
f:write("<br>" .. nListPaneCount .. " notes listed.<br>\n")

-- comment the next line if you do not want to brag about using NoteCase Pro
f:write("<br><p align=\"center\"><i>Exported to HTML by <a href=\"http://www.notecasepro.com/\">NoteCasePro</a></i></p>\n")

-- write closing BODY and HTML tags
f:write("</BODY></HTML>\n")

-- close the HTML file and save to disk
f:close()