-- Notecase Pro sample script (requires Notecase Pro >= 3.1.4)
--
-- Description:
-- Set read-only state to current note and all of its descendants 
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 4)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.4")
	return
end

-- get info on the currently active document/note
nDocID = Nc_Doc_ID_GetCur()
strCurNoteID = Nc_Note_ID_GetCur(nDocID)
if strCurNoteID == "" then
 	Nc_GUI_MessageBox("No note selected, aborting")
	return 
end

-- calculate new state to be set
bReadOnly = Nc_Note_Flag_ReadOnly_Get(nDocID, strCurNoteID)
if bReadOnly == 0  then
	bReadOnly = 1
else 	
	bReadOnly = 0
end

function ProcessNote(strNoteID)

	Nc_Note_Flag_ReadOnly_Set(nDocID, strNoteID, 1)

	local nChildCount = Nc_Note_ChildCount(nDocID, strNoteID)
	
	-- for each child
	for i=1,nChildCount do
		local strChildID = Nc_Note_Child_GetID(nDocID, strNoteID, i-1)
		ProcessNote(strChildID)
	end

end -- function

-- start processing
ProcessNote(strCurNoteID)
Nc_GUI_MessageBox("Done!")