-- Notecase Pro sample script (requires Notecase Pro >= 3.1.3)
--
-- Description:
-- fills the flat list view with all the notes that link to the currently selected document note
-- (faster variant of the old script 12_WhatLinksHere.lua)
--
-- This script's author, Miroslav Rajcic, hereby waives all copyright 
-- and related or neighboring rights to this script, pursuant to the
-- Creative Commons CC0 Universal relinquishment of rights found at
-- http://creativecommons.org/publicdomain/zero/1.0/

-- make sure app version supports necessary scriptable program commands
nMaj, nMin, nRev = Nc_Config_GetAppVersion()
if (nMaj < 3 or (nMaj == 3 and nMin < 1) or (nMaj == 3 and nMin == 1 and nRev < 3)) then
	Nc_GUI_MessageBox("ERROR: Script requires NcPro version >= 3.1.3")
	return
end

-- break string into the array
function lines(str)
  local t = {}
  local i, lstr = 1, #str
  while i <= lstr do
    local x, y = string.find(str, "\r?\n", i)
    if x then t[#t + 1] = string.sub(str, i, x - 1)
    else break
    end
    i = y + 1
  end
  if i <= lstr then t[#t + 1] = string.sub(str, i) end
  return t
end

-- get info on the currently active document/note
nDocID = Nc_Doc_ID_GetCur()
nNoteCount = Nc_Doc_NoteCount(nDocID)
strCurNoteID = Nc_Note_ID_GetCur(nDocID)

if strCurNoteID == "" then
 	Nc_GUI_MessageBox("No note selected, aborting")
	return 
end

Nc_App_List_Clear()
Nc_App_List_Switch(1)

-- for each document note
strNotesList = Nc_NoteGroup_NotesLinkingToMe_Get(nDocID, strCurNoteID)
-- replace delimiter with new line 
strNotesList = string.gsub(strNotesList, ";", "\n")
-- break string into the table with individual lines
local buf = lines(strNotesList) 

-- add the notes to the List Pane
nSize = #buf
for i=1, nSize do
	Nc_App_List_AddNote(buf[i])
end 
